# Player: huggingface_DeepSeek-V3-0324_PayoffMaximizer_A (as Player A)
# Meta-Round: 1
# Experiment: PMxPM, Run: 1
# API: huggingface, Model: deepseek-ai/DeepSeek-V3-0324
# Based on textual strategy: huggingface_DeepSeek_V3_0324_PayoffMaximizer_A_MR1_strategy.txt
# LLM Suggested Fallback: D

def huggingface_DeepSeek_V3_0324_PayoffMaximizer_A_MR1(my_history: list, opp_history: list, opponent_program_code: str) -> str:
    if not my_history:
        return "C"  # First round: Cooperate
    
    # Check if opponent's code is deterministic and always defects
    if "always defect" in opponent_program_code.lower() or "return 'D'" in opponent_program_code.lower():
        return "D"
    
    # Check if opponent's code is deterministic and always cooperates
    if "always cooperate" in opponent_program_code.lower() or "return 'C'" in opponent_program_code.lower():
        if len(my_history) % 3 == 0:  # Exploit every 3rd round
            return "D"
        else:
            return "C"
    
    # Tit-for-Tat with Forgiveness
    last_opponent_move = opp_history[-1]
    if last_opponent_move == "C":
        return "C"
    else:
        # 10% chance to forgive
        if random.random() < 0.1:
            return "C"
        else:
            return "D"